<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

class Com_TimetableInstallerScript {

    public function postflight($type, $parent) {
		$db = JFactory::getDBO();
		
		// install plugins
		$status = new stdClass;
		$status->plugins = array();
		$src = $parent->getParent()->getPath('source');
		$manifest = $parent->getParent()->manifest;
		$plugins = $manifest->xpath('plugins/plugin');
		foreach ($plugins as $plugin)
		{
			$name = (string)$plugin->attributes()->plugin;
			$group = (string)$plugin->attributes()->group;
			$path = $src.'/plugins/'.$group;
			if (JFolder::exists($src.'/plugins/'.$group.'/'.$name))
			{
			$path = $src.'/plugins/'.$group.'/'.$name;
			}
			$installer = new JInstaller;
			$result = $installer->install($path);
			if ($result && $group != 'finder')
			{
			JFile::move(JPATH_SITE.'/plugins/'.$group.'/'.$name.'/'.$name.'.xml', JPATH_SITE.'/plugins/'.$group.'/'.$name.'/'.$name.'.xml');
			}
			if($group != 'finder')
			{
			$query = "UPDATE #__extensions SET enabled=1 WHERE type='plugin' AND element=".$db->Quote($name)." AND folder=".$db->Quote($group);
			$db->setQuery($query);
			$db->query();
			}
			$status->plugins[] = array('name' => $name, 'group' => $group, 'result' => $result);
		}
		
		// install modules
		$modules = $manifest->xpath('modules/module');
		foreach ($modules as $module)
		{
			$name = (string)$module->attributes()->module;
			$client = (string)$module->attributes()->client;
			if (is_null($client))
			{
			$client = 'site';
			}
			($client == 'administrator') ? $path = $src.'/administrator/modules/'.$name : $path = $src.'/modules/'.$name;

			if($client == 'administrator')
			{
			$db->setQuery("SELECT id FROM #__modules WHERE `module` = ".$db->quote($name));
			$isUpdate = (int)$db->loadResult();
			}

			$installer = new JInstaller;
			$result = $installer->install($path);
			if ($result)
			{
			$root = $client == 'administrator' ? JPATH_ADMINISTRATOR : JPATH_SITE;
			JFile::move($root.'/modules/'.$name.'/'.$name.'.xml', $root.'/modules/'.$name.'/'.$name.'.xml');
			}
			$status->modules[] = array('name' => $name, 'client' => $client, 'result' => $result);
		}
		
    }
	
	function preflight($type, $parent) {}
}



